% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_focus.R
\name{layout_tbl_graph_focus}
\alias{layout_tbl_graph_focus}
\title{Place nodes in circles based on distance to a specific node}
\usage{
layout_tbl_graph_focus(
  graph,
  focus,
  weights = NULL,
  niter = 500,
  tolerance = 1e-04,
  group = NULL,
  shrink = 10,
  circular = TRUE
)
}
\arguments{
\item{graph}{a tbl_graph object}

\item{focus}{An expression evaluating to a selected node. Can either be a
single integer or a logical vector with a single \code{TRUE} element.}

\item{weights}{An expression evaluated on the edge data to provide edge
weights for the layout. Currently ignored for the sparse version}

\item{niter}{number of iterations during stress optimization}

\item{tolerance}{stopping criterion for stress optimization}

\item{group}{An expression evaluating to a grouping of the nodes. If given
the layout will keep grouped nodes within an angle range of the origin}

\item{shrink}{shrink the reserved angle range for a group to increase the
gaps between groups}

\item{circular}{ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular}, \code{distance} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This layout constrains node placement to a radius relative to its distance to
a given node. It then uses stress majorisation to find an optimal node
distribution according to this constraint.
}
\references{
Brandes, U., & Pich, C. (2011). \emph{More flexible radial layout.} Journal of
Graph Algorithms and Applications, 15(1), 157-173.
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_cactustree}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_htree}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_metro}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_sf}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\author{
The underlying algorithm is implemented in the graphlayouts package
by David Schoch
}
\concept{layout_tbl_graph_*}
